--Debouncer module
--TODO include reset
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity debouncer is


port 
(
clk		: in std_logic;
key_in 	: in std_logic;
key_out : out std_logic;
reset : in std_logic

);

end debouncer;

architecture ar1 of debouncer is
type states is (ZERO, ZERO_TO_ONE, ONE, ONE_TO_ZERO);
signal state, next_state : states;
signal do : unsigned(18 downto 0);
signal reset_counter: std_logic; --to reset the counter
begin


C0: entity work.DebounceCounter port map (
clk => clk,
reset => reset_counter,
do => do);



--FSM Strandard next_state => state
process(clk)
begin
if(rising_edge(clk)) then 
if( reset='1' )
then
state <= ZERO;
else
state <= next_state;
end if;
end if;
end process;


--Computation of the next state
process (state,key_in,do)
begin
next_state <= state;
case state is
--State ZERO
--Signal generated: reset => 1, key_out => 0
when ZERO =>
reset_counter <= '1';
key_out <= '1';
if (key_in = '0') 
then 
next_state <= ZERO_TO_ONE;
end if;

--State ZERO_TO_ONE
--Signal generated: reset => 0, key_out => 0
when ZERO_TO_ONE =>
reset_counter <= '0';
key_out <= '1';
if (do >= 500_000) 
then 
next_state <= ONE;
end if;
--State ONE
--Signal generated: reset => 1, key_out => 1
when ONE =>
reset_counter <= '1';
key_out <= '0';
if (key_in = '1')
then  
next_state <= ONE_TO_ZERO;
end if;
--State ONE_TO_ZERO
--Signal generated: reset => 0, key_out => 1
when ONE_TO_ZERO =>
reset_counter <= '0';
key_out <= '0';
if (do >= 500_000)
then  
next_state <= ZERO;
end if;
end case;
end process;

end ar1;
